VERSION 5.00
Begin VB.UserControl CapSOMQuoteValOf 
   ClientHeight    =   6615
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15690
   ScaleHeight     =   6615
   ScaleWidth      =   15690
   Begin Project1.CapSOMQuote uc_CapSOMQuote 
      Height          =   780
      Left            =   570
      TabIndex        =   20
      Top             =   5250
      Width           =   1095
      _extentx        =   1931
      _extenty        =   1376
   End
   Begin VB.Frame fra_ProjDetail 
      Height          =   2805
      Left            =   75
      TabIndex        =   0
      Tag             =   "fra_ProjDetail"
      Top             =   105
      Width           =   14970
      Begin VB.TextBox txt_zip1 
         BackColor       =   &H00FFFFFF&
         Height          =   330
         Left            =   1470
         MaxLength       =   10
         TabIndex        =   7
         Tag             =   "txt_zip1"
         Top             =   1200
         Width           =   960
      End
      Begin VB.TextBox txt_zip2 
         BackColor       =   &H00FFFFFF&
         Height          =   330
         Left            =   2460
         MaxLength       =   10
         TabIndex        =   8
         Tag             =   "txt_zip2"
         Top             =   1200
         Width           =   1020
      End
      Begin VB.TextBox txt_town 
         Height          =   285
         Left            =   1470
         MaxLength       =   80
         TabIndex        =   5
         Tag             =   "Proj_TownText"
         Text            =   "Proj_TownText"
         Top             =   855
         Width           =   7515
      End
      Begin VB.TextBox txt_duration 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   5430
         MaxLength       =   3
         TabIndex        =   16
         Tag             =   "Proj_durationNum0"
         Text            =   "999"
         Top             =   2175
         Visible         =   0   'False
         Width           =   525
      End
      Begin VB.TextBox txt_size 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   10155
         MaxLength       =   9
         TabIndex        =   10
         Tag             =   "Proj_SizeNum0"
         Text            =   "9,999,999"
         Top             =   1305
         Width           =   1065
      End
      Begin VB.TextBox txt_address1 
         Height          =   285
         Left            =   1470
         MaxLength       =   80
         TabIndex        =   3
         Tag             =   "Proj_Addr1Text"
         Text            =   "Proj_Addr1Text"
         Top             =   525
         Width           =   7515
      End
      Begin VB.TextBox txt_Desc 
         Height          =   285
         Left            =   1470
         MaxLength       =   80
         TabIndex        =   1
         Tag             =   "Proj_NameText"
         Text            =   "Proj_NameText"
         Top             =   195
         Width           =   7515
      End
      Begin VB.TextBox txt_AMCProjectNo 
         Height          =   285
         Left            =   12765
         MaxLength       =   15
         TabIndex        =   2
         Tag             =   "ProjectNumberText"
         Text            =   "ProjectNumberText"
         Top             =   195
         Width           =   2055
      End
      Begin VB.TextBox txt_I5No 
         Height          =   285
         Left            =   12765
         MaxLength       =   20
         TabIndex        =   4
         Tag             =   "Proj_i5RefText"
         Text            =   "Proj_i5RefText"
         Top             =   525
         Width           =   2055
      End
      Begin VB.TextBox txt_comment 
         Height          =   705
         Left            =   8325
         MaxLength       =   4000
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   17
         Tag             =   "Proj_CommentText"
         Text            =   "CapSOMQuoteValOf.ctx":0000
         Top             =   2025
         Width           =   6495
      End
      Begin VB.TextBox txt_PrjKey 
         Enabled         =   0   'False
         Height          =   330
         Left            =   12405
         Locked          =   -1  'True
         TabIndex        =   6
         Tag             =   "txt_PrjKey"
         Top             =   855
         Width           =   2415
      End
      Begin Project1.ArmCombobox cbo_status 
         Height          =   345
         Left            =   1470
         TabIndex        =   12
         Tag             =   "PS_code"
         Top             =   1575
         Width           =   2955
         _ExtentX        =   5212
         _ExtentY        =   609
      End
      Begin Project1.A_calocx cal_followUpDate 
         Height          =   345
         Left            =   1920
         TabIndex        =   14
         Tag             =   "Proj_Followupdate"
         Top             =   1965
         Width           =   1845
         _ExtentX        =   3254
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_UOM 
         Height          =   345
         Left            =   12195
         TabIndex        =   11
         Tag             =   "UM_code"
         Top             =   1245
         Width           =   2625
         _ExtentX        =   4630
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_country 
         Height          =   345
         Left            =   4800
         TabIndex        =   9
         Tag             =   "CT_code"
         Top             =   1185
         Width           =   4185
         _ExtentX        =   7382
         _ExtentY        =   609
      End
      Begin Project1.A_calocx cal_orderExpDate 
         Height          =   345
         Left            =   1920
         TabIndex        =   15
         Tag             =   "Proj_Exporderdate"
         Top             =   2355
         Visible         =   0   'False
         Width           =   1845
         _ExtentX        =   3254
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_ceilFncType 
         Height          =   345
         Left            =   11865
         TabIndex        =   13
         Tag             =   "Cf_code"
         Top             =   1635
         Width           =   2955
         _ExtentX        =   5212
         _ExtentY        =   609
      End
      Begin VB.Label lbl_label 
         Caption         =   "#Weeks"
         Height          =   225
         Index           =   47
         Left            =   6000
         TabIndex        =   38
         Tag             =   "lbl_ProjectWeeks"
         Top             =   2235
         Visible         =   0   'False
         Width           =   1095
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Duration"
         Height          =   225
         Index           =   46
         Left            =   3810
         TabIndex        =   37
         Tag             =   "lbl_ProjectDuration"
         Top             =   2235
         Visible         =   0   'False
         Width           =   1575
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Follow up date"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   44
         Left            =   150
         TabIndex        =   36
         Tag             =   "lbl_FollowUp"
         Top             =   2070
         Width           =   1725
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Size"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   42
         Left            =   9120
         TabIndex        =   35
         Tag             =   "lbl_Size"
         Top             =   1365
         Width           =   990
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Status"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   41
         Left            =   30
         TabIndex        =   34
         Tag             =   "lbl_ProjStatus"
         Top             =   1695
         Width           =   1395
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#ZipCode"
         Height          =   225
         Index           =   39
         Left            =   30
         TabIndex        =   33
         Tag             =   "lbl_ProjZipCode"
         Top             =   1305
         Width           =   1395
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Address"
         Height          =   225
         Index           =   38
         Left            =   30
         TabIndex        =   32
         Tag             =   "lbl_ProjAddress"
         Top             =   585
         Width           =   1395
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Project"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   36
         Left            =   30
         TabIndex        =   31
         Tag             =   "lbl_ProjectName"
         Top             =   255
         Width           =   1395
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Exp order date"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   45
         Left            =   195
         TabIndex        =   30
         Tag             =   "lbl_ExpOrder"
         Top             =   2475
         Visible         =   0   'False
         Width           =   1680
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Town"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   48
         Left            =   30
         TabIndex        =   29
         Tag             =   "lbl_ProjTown"
         Top             =   915
         Width           =   1395
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Country"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   0
         Left            =   3495
         TabIndex        =   28
         Tag             =   "lbl_ProjectCountry"
         Top             =   1245
         Width           =   1260
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Project Number"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   1
         Left            =   9105
         TabIndex        =   27
         Tag             =   "lbl_ProjectNum"
         Top             =   255
         Width           =   3615
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#I5 Project reference"
         Height          =   225
         Index           =   2
         Left            =   9135
         TabIndex        =   26
         Tag             =   "lbl_ProjectI5Ref"
         Top             =   585
         Width           =   3585
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#in"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   8
         Left            =   11295
         TabIndex        =   25
         Tag             =   "lbl_in"
         Top             =   1365
         Width           =   855
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Ceiling function"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   225
         Index           =   3
         Left            =   9525
         TabIndex        =   24
         Tag             =   "lbl_ClgFunction"
         Top             =   1755
         Width           =   2295
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Comments"
         Height          =   225
         Index           =   30
         Left            =   6975
         TabIndex        =   23
         Tag             =   "lbl_Proj_Comment"
         Top             =   2055
         Width           =   1305
      End
      Begin VB.Label lbl_PrjKey 
         Alignment       =   1  'Right Justify
         Caption         =   "#Project Key"
         Enabled         =   0   'False
         Height          =   255
         Left            =   9120
         TabIndex        =   22
         Tag             =   "lbl_PrjKey"
         Top             =   915
         Width           =   3195
      End
   End
   Begin VB.Frame Fra_WLD 
      Height          =   3390
      Left            =   90
      TabIndex        =   18
      Top             =   2910
      Width           =   14985
      Begin Project1.ArmGrid grd_WLD 
         Height          =   2040
         Left            =   75
         TabIndex        =   19
         Tag             =   "grd_WLD"
         Top             =   960
         Width           =   14775
         _ExtentX        =   26061
         _ExtentY        =   3598
      End
      Begin Project1.ToolbarControl tbl_WLD 
         Height          =   690
         Left            =   75
         TabIndex        =   21
         Top             =   195
         Width           =   5265
         _ExtentX        =   9287
         _ExtentY        =   1217
      End
   End
End
Attribute VB_Name = "CapSOMQuoteValOf"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Option Compare Text
'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK API FUNCTION DECLARES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetSystemDefaultLCID Lib "kernel32" () As Long



'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK VARIABLES
'**********************************************************************************************************************************
'**********************************************************************************************************************************

#If ENV = LIVE Then
    Dim mo_Db As Object
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
#End If

Private ms_Language_Code                As String       'current user interface language
Private ml_U_code                       As Long         'U_Code (GEN_Systems_Users) of logged user
Private ms_LoginName                    As String       'contain loginname
Private mb_InternalInit                 As Boolean      'framework is doing some own control manipulation, all events should handle

Private mb_Initialized                  As Boolean      'framework is initialised or not
Private m_ConnectString                 As String       'connection string to connect SQL database
Private use_framework_connection        As Integer      'if framework should use outside connected armdb or its own connection
Private ms_DecimalSeparator             As String       'locale decimal separator
Private ms_ThousandSeparator            As String       'locale thousand separator


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CONSTANTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Const SCREEN_NAME As String = "CapSOMQuoteValOf"
Private Const LOCALE_USER_DEFAULT = &H400

Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const CL_COLOR_LOCKED As Long = &H80000018
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9350

Private Const FRM_SPACE_VER = 120
Private Const FRM_SPACE_HOR = 100
Private mt_CstValues As Type_CstValues         ' Structure which contains constants value


Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum

Private Enum eQuoteStatus
    eQuoteWon = 1
    eQuoteLost = 2
    eQuoteDuplicated = 3
    eQuoteCancelled = 4
    eQuoteActive = 5
End Enum

Private Enum eInclude
    eInclActive = 1
    eInclMultiple = 2
End Enum

Private mb_Validated As Boolean
Private ms_SP As String
Private ms_CT_Code As String
Private ml_SS_Code As Long
Private ml_prjIconc As Long


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK EVENTS
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Event quit()

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK CUSTOM METHODS
' Change content of methods as you need, but do not add any new method or property here !
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Private Function Load_A_COM_Custom() As Boolean
On Error GoTo ErrHandler

    cal_orderExpDate.opening_toward_top = 1
    cal_followUpDate.opening_toward_top = 1
    
    Call uc_CapSOMQuote.FrameWorkInit(mt_CstValues, "NOT USED")
    uc_CapSOMQuote.Language = ms_Language_Code
    uc_CapSOMQuote.U_Code = prg.U_Code
    uc_CapSOMQuote.ConnectString = prg.CurrentServerIP & prg.ServerInstance & CH_LDELIMIT & prg.DBName & CH_LDELIMIT & prg.LoginName & CH_LDELIMIT & prg.U_PWD & CH_LDELIMIT & "SPA_Main"
    uc_CapSOMQuote.Visible = False

'    ao_ctrl.FullUserName = ms_FullUserName
    Set uc_CapSOMQuote.ArmDb = mo_Db
    Call uc_CapSOMQuote.Load_A_Com(True)


    Load_A_COM_Custom = True
    Exit Function
ErrHandler:
    Call ErrorHandler("Load_A_COM_Custom")
End Function

Private Sub UnLoad_A_COM_Custom()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorHandler("UnLoad_A_COM_Custom")
End Sub

Private Sub Init_Custom()
On Error GoTo ErrHandler
    
    cbo_ceilFncType.FirstBlankItem = False
    cbo_ceilFncType.Request = "EXEC SOM_ClgFunction_cbo '" & ms_Language_Code & "'"

    cbo_status.FirstBlankItem = False
    cbo_status.SearchPrefix = " "
    cbo_status.Request = "exec cap_salesstatus_cbo " & "'" & ms_LoginName & "', '" & ms_Language_Code & "'"

    cbo_UOM.FirstBlankItem = False
    cbo_UOM.Request = "exec unit_of_measure_cbo " & "'" & ms_Language_Code & "'"

    Call LoadToolbar(tbl_WLD, 2423)
    Call tbl_WLD.DisplayFace("1")

    grd_WLD.Title = "#Quotation Won Lost Duplicate"
    grd_WLD.AllowExcelExport = False
    grd_WLD.AllowPrint = False
    grd_WLD.MultiSelect = False
    grd_WLD.FreeSelect = True
    grd_WLD.FetchAll = True
    
    ReDim lColumns(14)
    lColumns(0) = Join(Array("SQT_ID", 0, 0, "SQT_ID", "#Quote_ID"), SEP)
    lColumns(1) = Join(Array("SQT_Reference", 1500, 0, "SQT_Reference", "#Reference"), SEP)
    lColumns(2) = Join(Array("SQT_Include", 0, 0, "SQT_Include", "#Quote_Include"), SEP)
    lColumns(3) = Join(Array("SQT_Include_desc", 700, 0, "SQT_Include_desc", "#Include"), SEP)
    lColumns(4) = Join(Array("TOT_Quote_Area", 1200, 0, "TOT_Quote_Area", "#Volume"), SEP)
    lColumns(5) = Join(Array("TOT_UM_System", 1000, 0, "TOT_UM_System", "#In"), SEP)
    lColumns(6) = Join(Array("TOT_Quote_Value_CHF", 1200, 0, "TOT_Quote_Value_CHF", "#Value"), SEP)
    lColumns(7) = Join(Array("TOT_Quote_DB", 600, 0, "TOT_Quote_DB", "#DB%"), SEP)
    lColumns(8) = Join(Array("TOT_Quote_PrimeMargin", 1200, 0, "TOT_Quote_PrimeMargin", "#Prime margin", "Float", "0.00"), SEP)
    lColumns(9) = Join(Array("CCU_Desc", 3000, 0, "CCU_Desc", "#Customer"), SEP)
    lColumns(10) = Join(Array("SQT_Status", 0, 0, "SQT_Status", "#Status"), SEP)
    lColumns(11) = Join(Array("iConcurrency", 0, 0, "iConcurrency", "#iConcurrency"), SEP)
    lColumns(12) = Join(Array("Won", 1000, 0, "Won", "#Won", "BITMAP"), SEP)
    lColumns(13) = Join(Array("Lost", 1000, 0, "Lost", "#Lost", "BITMAP"), SEP)
    lColumns(14) = Join(Array("Duplicated", 1000, 0, "Duplicated", "#Duplicated", "BITMAP"), SEP)
    
    Call grd_WLD.SetColumns(lColumns)


    Exit Sub
ErrHandler:
    Call ErrorHandler("Init_Custom")
End Sub


'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK PROPERTIES
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property

Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Property Let Top(ByVal aTop As Single)
    UserControl.Extender.Top = aTop
End Property
Public Property Get Top() As Single
    Top = UserControl.Extender.Top
End Property

Public Property Let Height(ByVal aHeight As Single)
    UserControl.Extender.Height = aHeight
End Property
Public Property Get Height() As Single
    Height = UserControl.Extender.Height
End Property

Public Property Let Left(ByVal aLeft As Single)
    UserControl.Extender.Left = aLeft
End Property
Public Property Get Left() As Single
    Left = UserControl.Extender.Left
End Property

Public Property Let Width(ByVal aWidth As Single)
    UserControl.Extender.Width = aWidth
End Property
Public Property Get Width() As Single
    Width = UserControl.Extender.Width
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Get ConnectString() As String
    ConnectString = m_ConnectString
End Property

Property Let LoginName(as_Login As String)
ms_LoginName = as_Login
End Property

Property Let U_Code(al_Code As Long)
ml_U_code = al_Code
End Property

Property Let Language_Code(AString As String)
ms_Language_Code = AString
End Property

Public Property Get Validated() As Boolean
    Validated = mb_Validated
End Property

Public Property Set ArmDb(ByRef local_connection As Object)
    If Not (local_connection Is Nothing) Then
        Set mo_Db = local_connection
    End If
End Property

Public Property Set CstValues(ByRef at_CstValues As Type_CstValues)
    Set mt_CstValues = at_CstValues
End Property

Public Property Let ProjectStatus(ByVal al_SS_Code As Long)
    ml_SS_Code = al_SS_Code
End Property

Public Property Let ProjectIConc(ByVal al_iCOnc As Long)
    ml_prjIconc = al_iCOnc
End Property

'**********************************************************************************************************************************
'**********************************************************************************************************************************
' FRAMEWORK METHODS
' please DO NOT change anything in this part of code
'**********************************************************************************************************************************
'**********************************************************************************************************************************

Public Function Load_A_Com() As Boolean

Dim ll_Index As Long
Dim lo_Control As Object

On Error GoTo ErrHandler
    
    Load_A_Com = False
    
    If mb_Initialized Then
        Call Err.Raise(ArmErr.CPTAlreadyInitialized)
    End If
    
    mb_InternalInit = False
    ms_DecimalSeparator = Format(0, ".")
    
    ReDim mt_MainConfig(-1 To -1)
    ReDim mt_DetailConfig(-1 To -1)
    ReDim mt_SubdetailConfig(-1 To -1)
    
    Dim sBuffer As String
    Dim nBufferLen As Long
    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMPICKER"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "TOOLBARCONTROL"
            lo_Control.Language = ms_Language_Code
            lo_Control.Load_A_Com
        Case "ARMGRID"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "ARMTREEVIEW"
            Set lo_Control.ArmDb = mo_Db
            lo_Control.Language = ms_Language_Code
            Call lo_Control.Load_A_Com
        Case "ARMCHECKVIEW"
            Set lo_Control.ArmDb = mo_Db
            Call lo_Control.Load_A_Com
        Case "A_CALOCX"
            lo_Control.Language = ms_Language_Code
            Call lo_Control.reinit_cal
        End Select
    Next
    
    mb_Initialized = Load_A_COM_Custom
    Load_A_Com = mb_Initialized
    Exit Function
ErrHandler:
    Load_A_Com = False
    Call ErrorMessage("Load_A_COM")
End Function

Public Function Unload_A_Com() As Boolean
    
On Error GoTo ErrHandler
    
    Dim lo_Control As Object
    Dim ll_Index As Long
    
    Call UnLoad_A_COM_Custom
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX", "TOOLBARCONTROL", "ARMGRID", "ARMTREEVIEW", "ARMCHECKVIEW", "ARMPICKER"
            Call lo_Control.Unload_A_Com
        End Select
    Next
    
    Set mo_Db = Nothing
    mb_Initialized = False
    Unload_A_Com = True
    Exit Function
ErrHandler:
    Unload_A_Com = False
    Call ErrorMessage("Unload_A_Com")
End Function

Public Sub Resize()
On Error GoTo ErrHandler

    Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Public Function Init_control() As Boolean
Dim ll_Index As Long

On Error GoTo ErrHandler

    Call Init_Custom
    
    Call ChangeCharset(UserControl.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    Call LoadLabels(mo_Db, Me, SCREEN_NAME, ms_Language_Code)
    
    Init_control = True
    Exit Function
ErrHandler:
    Init_control = False
    Call ErrorMessage("Init_control")
End Function

Private Function HasContainer(ByVal lo_Control As Control, ByRef lo_Container As Object) As Boolean
    Dim ll_Index As Long
    Dim lo_Object As Object

    On Error GoTo CleanUp   'not all controls support Container property
    HasContainer = False
    While Not (lo_Control Is Nothing)
        If lo_Control.Container Is lo_Container Then
            HasContainer = True
            Exit Function
        End If
        Set lo_Control = lo_Control.Container
    Wend

CleanUp:

End Function

Private Sub ResetFrameControls(ByRef ao_Frame As Frame)
On Error GoTo ErrHandler

Dim lo_Control As Control

    mb_InternalInit = True
    For Each lo_Control In UserControl.Controls
    
        If HasContainer(lo_Control, ao_Frame) Then
            Select Case UCase(TypeName(lo_Control))
                Case "ARMCOMBOBOX"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Request = ""
                    lo_Control.Visible = False
                Case "ARMPICKER"
                    Call lo_Control.Clear
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "CHECKBOX"
                    lo_Control.value = Unchecked
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.Visible = False
                Case "TEXTBOX"
                    lo_Control.Tag = ""
                    lo_Control.Text = ""
                    lo_Control.Visible = False
                Case "A_CALOCX"
                    Call lo_Control.reinit_cal
                    lo_Control.Tag = ""
                    lo_Control.Visible = False
                Case "LABEL"
                    lo_Control.Tag = ""
                    lo_Control.Caption = ""
                    lo_Control.FontBold = False
                    lo_Control.Visible = False
            End Select
        End If
    Next
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    mb_InternalInit = False
    Call ErrorHandler("ResetFrameControls")
End Sub

Private Sub LoadToolbar(ByRef ao_toolbar As Object, ByVal al_ID As Long)
On Error GoTo ErrHandler

Dim ls_Request As String
Dim ls_ToolbarInfo As String
Dim ll_Cursor As Long

    ' no toolbar definition ID, do not load anything
    If (al_ID = 0) Then Exit Sub
    'load all definition strings only once and keep it in cursor
    ls_Request = ReplacePlaceHolder("exec Toolbar_sel $Module$", "$Module$", SQLStr("SOM_Gema"))
    ll_Cursor = OpenSQLSafe(mo_Db, ls_Request)
    
    If mo_Db.Find(ll_Cursor, "Id", al_ID) < 0 Then
        Err.Raise ArmErr.InvalidValue, ao_toolbar.Name, "Toolbar not found in toolbars_definitions ID:" & al_ID
    End If

    ls_ToolbarInfo = mo_Db.GetFields(ll_Cursor, "info")
    If Not ao_toolbar.SetToolbarInfoStringParameters(ls_ToolbarInfo, Left(ls_ToolbarInfo, 3)) Then
        Err.Raise ArmErr.InvalidValue, ao_toolbar.Name, "SetToolbarInfoStringParameters failed for toolbar ID:" & al_ID
    End If

    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Call ao_toolbar.DisplayFace("0")
    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("LoadToolbar")
End Sub


Private Sub ClearFrame(ByRef ao_Controls As Object, ByVal ao_Frame As Frame)
On Error GoTo ErrHandler

Dim ll_Idx As Long, ll_Count As Long, lo_Control As Object

   mb_InternalInit = True
    ll_Count = ao_Controls.Count - 1
    For ll_Idx = 0 To ll_Count
        Set lo_Control = ao_Controls.Item(ll_Idx)
        
        If StrComp(lo_Control.Name, "chk_Repositioning", vbTextCompare) <> 0 Then
        
            If HasContainer(lo_Control, ao_Frame) Then
                Select Case UCase(TypeName(lo_Control))
                    Case "TEXTBOX"
                        lo_Control.Text = ""
                    Case "ARMCOMBOBOX"
                        Set lo_Control.SelectedItem = Nothing
                    Case "ARMPICKER"
                        Call lo_Control.Clear
                    Case "A_CALOCX"
                        lo_Control.reinit_cal
                    Case "CHECKBOX"
                        lo_Control.value = vbUnchecked
                    Case "ARMCHECKVIEW"
                        Call lo_Control.Init
                        Call RemoveDroppedCheckItems(lo_Control)
                    Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON", _
                         "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX", "LISTVIEW"
                        'do nothing
                    Case "ARMGRID"
                        lo_Control.ClearGrid
                        lo_Control.Requests = ""
                    Case "LISTBOX"
                        lo_Control.ListIndex = -1
                    Case "OPTIONBUTTON"
                        Dim lv_Values As Variant
                        lv_Values = Split(lo_Control.Tag, SEP)
                        If UBound(lv_Values) >= 1 Then
                            lo_Control.value = lv_Values(1)
                        Else
                            lo_Control.value = False
                        End If
                    Case "ARMTREEVIEW"
                        Call lo_Control.Clear
                    Case Else
                        Debug.Print "ClearFrame " & UCase(TypeName(lo_Control))
                End Select
            End If
        End If
    Next
    Set lo_Control = Nothing
    mb_InternalInit = False
    Exit Sub
ErrHandler:
    Set lo_Control = Nothing
    mb_InternalInit = False
    Call ErrorHandler("ClearFrame")
End Sub

Private Sub EnableFrame(ByRef aControls As Variant, ByRef aContainer As Object, ByVal ab_Enabled As Boolean)
On Error GoTo ErrHandler
    
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TOOLBARCONTROL"
                    'lControl.Visible = ab_Enabled
                
                Case "FRAME", "LABEL", "MSFLEXGRID"
                    ' Do nothing !
                
                Case "TEXTBOX"
                    lControl.Locked = Not ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
                
                Case "ARMGRID", "TABSTRIP"
                
                Case "ARMCHECKVIEW"
                    If ab_Enabled Then
                        Call lControl.SetVisibleList("EDIT")
                    Else
                        Call lControl.SetVisibleList("VIEW")
                    End If
                    
                Case "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX"
                    lControl.Enabled = ab_Enabled
                    lControl.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)

                Case "LISTVIEW", "COMMANDBUTTON", "ARMCOMBOBOX", "ARMPICKER", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX"
                    lControl.Enabled = ab_Enabled
                Case Else
                    lControl.Enabled = ab_Enabled
                    Debug.Print "EnableFrame " & UCase(TypeName(lControl))
            End Select
        End If
        Set lControl = Nothing
    Next
    Exit Sub
ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("EnableFrame")
End Sub


' ************************************************************************************
' FRAMEWORK DB-ACCESS FUNCTIONS
' please do not change this code
' ************************************************************************************

' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If ENV = LIVE Then
Private Function OpenSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_DB.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_DB.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function


' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If ENV = LIVE Then
Private Sub ExecuteSQLSafe(ByVal ao_DB As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_DB As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_DB.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_DB.SQLErrorCodes, SEP2) & SEP1 & Join(ao_DB.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_DB.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_DB.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(mo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function
' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_ErrDescription As String
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_ErrDescription = Err.Description
    
    Call LogMessage(SCREEN_NAME & " exception raised. Err.Number:" & Err.Number & ", Err.Source:" & ls_ErrSource & ", Err.Description " & ls_ErrDescription & ".", "E", False)
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_ErrDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "E", Optional ab_ExitOnException As Boolean = False)
    Dim ll_errNumber As Long
    Dim ls_ErrDescription As String, ls_ErrSource As String
    
    ll_errNumber = Err.Number
    ls_ErrDescription = Err.Description
    ls_ErrSource = Err.Source

On Error GoTo ErrHandler

Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    Dim ls_Req As String
    Dim ll_Cursor As Long
    Dim ls_Source As String, ls_Msg As String
    
    ls_Source = SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    ls_Msg = as_logMsg & SEP1 & ll_errNumber & " : " & ls_ErrDescription & " - " & ls_ErrSource
    
    ls_Req = ReplacePlaceHolder(LOG_REQUEST, "$UCODE$", CStr(ml_U_code))
    ls_Req = ReplacePlaceHolder(ls_Req, "$LOGTYPE$", SQLStr(as_logType))
    ls_Req = ReplacePlaceHolder(ls_Req, "$MSG$", Left(Trim(SQLStr(ls_Msg)), 4000))
    ls_Req = ReplacePlaceHolder(ls_Req, "$APP$", Left(Trim(SQLStr(ls_Source)), 50))
    
    Call ExecuteSQLSafe(mo_Db, ls_Req)
    
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
    Exit Sub
    
ErrHandler:
    If ab_ExitOnException Then
        Call MsgBox("A fatal error occured. Unable to log error into database, the application will be close. Please report the following message to your IT support: " & vbCrLf & _
            "Number:" & Err.Number & vbCrLf & "Description:" & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End If
    Err.Number = ll_errNumber
    Err.Description = ls_ErrDescription
    Err.Source = ls_ErrSource
End Sub

Private Function SQLStr(ByVal as_Data As String) As String
On Error GoTo ErrHandler

    SQLStr = "'" & Replace(as_Data, "'", "''") & "'"
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlStr")
End Function

Private Function ReplacePlaceHolder(ByVal as_Request As String, ByVal as_PlaceHolder As String, ByVal as_DefaultValue As String) As String
On Error GoTo ErrHandler
    
    as_Request = Replace(as_Request, as_PlaceHolder, as_DefaultValue, , , vbTextCompare)
    
    ReplacePlaceHolder = as_Request
    Exit Function
ErrHandler:
    Call ErrorHandler("ReplacePlaceholder")
End Function

Private Function GetNextID(ByVal as_Key As String) As String
On Error GoTo ErrHandler
Dim ls_Data As String

    ls_Data = mo_Db.SQLNextID(as_Key)
    If ls_Data = "" Then
        Err.Raise ArmErr.CompFncFailed, "mo_Db.SQLNextID", "SQLNextID failed for key: " & as_Key
    End If
    GetNextID = ls_Data
    Exit Function
ErrHandler:
    Call ErrorHandler("GetNextID()")
End Function

' procedure save/restore err object
Private Sub UpdateError(Optional ab_saveError As Boolean = False)
Static ls_ErrDesc As String
Static ls_ErrSource As String
Static ll_errnum As Long
    
    If ab_saveError Then
        ls_ErrDesc = Err.Description
        ls_ErrSource = Err.Source
        ll_errnum = Err.Number
    Else
        Err.Description = ls_ErrDesc
        Err.Source = ls_ErrSource
        Err.Number = ll_errnum
    End If
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        UserControl.Enabled = False
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Enabled = True
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    Exit Sub
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub


' ************************************************************************************
' *************************** INTERNATIONAL FUNCTIONS ********************************
' ************************************************************************************

Private Function GetCodePageFromLanguage(ByRef ao_Armdb As Object, ByVal as_Language As String) As Long
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT Code_Page FROM Language WHERE Language_Code = '$Language_Code$'"
    Dim ls_Req As String
    Dim ll_Cursor As Long
    Dim ll_codePage As Long
    
    ls_Req = ReplacePlaceHolder(C_REQ, "$Language_Code$", as_Language)

    ll_Cursor = OpenSQLSafe(ao_Armdb, ls_Req)
    Debug.Assert (ll_Cursor <> 0)
    
    ll_codePage = CLng(ao_Armdb.GetFields(ll_Cursor, "Code_Page"))
    Call ao_Armdb.Close(ll_Cursor)
    GetCodePageFromLanguage = ll_codePage
    Exit Function
    
ErrHandler:
    If ll_Cursor <> 0 Then Call ao_Armdb.Close(ll_Cursor)
    Call ErrorHandler("GetCodePageFromLanguage()")
End Function

'convert code page into charset integer
Private Function GetCharSetFromCodePage(ByVal al_CodePage As Long) As Long

On Error GoTo ErrHandler

    Select Case CStr(al_CodePage)
        Case 932 ' Japanese
            GetCharSetFromCodePage = 128
        Case 936 ' Simplified Chinese
            GetCharSetFromCodePage = 134
        Case 949 ' Korean
            GetCharSetFromCodePage = 129
        Case 950 ' Traditional Chinese
            GetCharSetFromCodePage = 136
        Case 1250 ' Eastern Europe
            GetCharSetFromCodePage = 238
        Case 1251 ' Russian
            GetCharSetFromCodePage = 204
        Case 1252 ' Western European Languages
            GetCharSetFromCodePage = 0
        Case 1253 ' Greek
            GetCharSetFromCodePage = 161
        Case 1254 ' Turkish
            GetCharSetFromCodePage = 162
        Case 1255 ' Hebrew
            GetCharSetFromCodePage = 177
        Case 1256 ' Arabic
            GetCharSetFromCodePage = 178
        Case 1257 ' Baltic
            GetCharSetFromCodePage = 186
        Case Else
            GetCharSetFromCodePage = 0
    End Select
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetCharSetFromCodePage()")
End Function

Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)

On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0", "ARMPICKER"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ChangeCharset")
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef ao_Armdb As ArmDb, ByRef ao_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)
Dim lo_Control As Control   ' A control of the container
Dim li_Idx As Integer, li_Count As Integer
Dim li_Label As Integer      ' A label idx
Dim ls_Request As String
Dim lc_Labels As Long
Dim lsa_ControlTag() As String
    
    On Error GoTo Trace_Err

    ls_Request = "exec screen_csts '" & as_ScreenName & "','" & as_Language & "'"
    lc_Labels = OpenSQLSafe(ao_Armdb, ls_Request)
    
    On Error GoTo WithoutTag
    If ao_Container.Tag <> "" Then
        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", ao_Container.Tag, , 1)
        If li_Label >= 0 Then
            ao_Container.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
        End If
    End If
WithoutTag:
    
    On Error GoTo Trace_Err
    
    ' Iterate the container for loading the label of each element which has defined a tag
    For Each lo_Control In UserControl.Controls
        
        If HasContainer(lo_Control, ao_Container) Or _
          ((ao_Container Is Me) And (UCase(TypeName(lo_Control)) = "MENU")) Then
            Select Case UCase(TypeName(lo_Control))
                Case UCase("TabStrip") ' Component is a tabstrip, we load the caption of each tab defined
                    Dim lo_Tbs
                    Set lo_Tbs = lo_Control ' Cast for use of intellisense
                    li_Count = lo_Tbs.Tabs.Count
                    For li_Idx = 1 To li_Count
                        If lo_Tbs.Tabs(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Tbs.Tabs(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_Tbs.Tabs(li_Idx).Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_Tbs = Nothing
                
                Case UCase("ListView") ' Component is a listview, we load the caption of each columns
                    Dim lo_ListView As ListView
                    Set lo_ListView = lo_Control
                    li_Count = lo_ListView.ColumnHeaders.Count
                    For li_Idx = 1 To li_Count
                        If lo_ListView.ColumnHeaders(li_Idx).Tag <> "" Then
                            li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_ListView.ColumnHeaders(li_Idx).Tag, , 1)
                            If li_Label >= 0 Then
                                lo_ListView.ColumnHeaders(li_Idx).Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                            End If
                        End If
                    Next
                    Set lo_ListView = Nothing
            
                Case UCase("TextBox")  ' Component is a textbox
                    Dim lo_TextBox As TextBox
                    Set lo_TextBox = lo_Control
                    If lo_TextBox.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_TextBox.Text = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                    Set lo_TextBox = Nothing
                
                Case UCase("Label"), UCase("Frame"), UCase("CommandButton"), UCase("CheckBox"), UCase("OptionButton")
                    If lo_Control.Tag <> "" Then
                        lsa_ControlTag = Split(lo_Control.Tag, SEP)
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lsa_ControlTag(0), , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
                Case UCase("ArmGrid")
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                    If li_Label >= 0 Then
                      Call lo_Control.LoadConstants(ptStatic, ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT"), ctColumns)
                    End If
                    li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag & "_Title", , 1)
                    If li_Label >= 0 Then
                      lo_Control.Title = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                    End If
                Case UCase("Menu")
                    If lo_Control.Tag <> "" Then
                        li_Label = ao_Armdb.Find(lc_Labels, "FIELD_NAME", lo_Control.Tag, , 1)
                        If li_Label >= 0 Then
                            lo_Control.Caption = ao_Armdb.GetFields(lc_Labels, "LOCAL_TEXT")
                        End If
                    End If
            End Select
        End If
    Next
    
    Call mo_Db.Close(lc_Labels)
    lc_Labels = 0
        
Trace_End:
    Exit Sub
    
Trace_Err:
    If lc_Labels > 0 Then
        Call mo_Db.Close(lc_Labels)
        lc_Labels = 0
    End If
      
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = ReplacePlaceHolder(DB_REQ, "$id$", aID)
    lRequest = ReplacePlaceHolder(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.", vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    MsgText = aDefault
End Function


Private Sub RemoveDroppedCheckItems(ByRef ao_chkview As ArmCheckView)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim ll_Count As Long
Dim lo_ItemInfo As ArmItemInfo

    ll_Count = ao_chkview.RoleList("EDIT").Count
    For ll_Index = ll_Count To 1 Step -1
        Set lo_ItemInfo = ao_chkview.RoleList("EDIT").Items(ll_Index)
        If UBound(lo_ItemInfo.Data) > 1 Then
            Call ao_chkview.RoleList("EDIT").Items.Remove(ll_Index)
        End If
        Set lo_ItemInfo = Nothing
    Next
    Call ao_chkview.RoleList("EDIT").DisplayList
    Exit Sub
ErrHandler:
    Call ErrorHandler("RemoveDroppedCheckItems")
End Sub



Public Sub Run(ByVal as_SP As String)
On Error GoTo ErrHandler
    
    ms_SP = as_SP
    Item_ViewInit (as_SP)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Run")
End Sub


Private Sub Item_Load(ByVal as_Key As String)
On Error GoTo ErrHandler
    Const REQ_GRD_WLD As String = "exec Cap_SOM_Quote_lst2 '$SP_CAPKEY$', '$Language_code$'"

Dim ls_Req As String
Dim ll_frameIndex As Long
Dim ll_Cursor As Long

    ls_Req = "EXEC sales_project_t_sel3 '$SP_CAPKEY$', '$LANGUAGE_CODE$'"
    ls_Req = ReplacePlaceHolder(ls_Req, "$SP_CAPKEY$", as_Key)
    ls_Req = ReplacePlaceHolder(ls_Req, "$LANGUAGE_CODE$", ms_Language_Code)
    
    'load data
    ll_Cursor = OpenSQLSafe(mo_Db, ls_Req, 1)
    
    txt_PrjKey.Text = mo_Db.GetFields(ll_Cursor, "SP_CapKey")
    txt_desc.Text = mo_Db.GetFields(ll_Cursor, "SP_desc")
    txt_address1.Text = mo_Db.GetFields(ll_Cursor, "SP_addr1")

    txt_AMCProjectNo.Text = mo_Db.GetFields(ll_Cursor, "AMCProjectNumber")
    txt_duration.Text = mo_Db.GetFields(ll_Cursor, "AMCProjDuration")
    txt_I5No.Text = mo_Db.GetFields(ll_Cursor, "AMCI5Ref")
    cbo_ceilFncType.AddItem Array(CStr(mo_Db.GetFields(ll_Cursor, "AMCCF_Code")), mo_Db.GetFields(ll_Cursor, "Cf_desc")), True
    cal_orderExpDate.date_courte = mo_Db.GetFields(ll_Cursor, "AMCExpiryOrderDate")
    cal_followUpDate.date_courte = mo_Db.GetFields(ll_Cursor, "sp_datefollowup")
    
    txt_town.Text = mo_Db.GetFields(ll_Cursor, "SP_town")
    txt_zip1.Text = mo_Db.GetFields(ll_Cursor, "SP_zip1")
    txt_zip2.Text = mo_Db.GetFields(ll_Cursor, "SP_zip2")
    txt_size.Text = mo_Db.GetFields(ll_Cursor, "SP_size")
    txt_comment.Text = mo_Db.GetFields(ll_Cursor, "SP_Comment")
    
    cbo_country.AddItem Array(CStr(mo_Db.GetFields(ll_Cursor, "CT_code")), mo_Db.GetFields(ll_Cursor, "CT_desc")), True
    cbo_UOM.AddItem Array(CStr(mo_Db.GetFields(ll_Cursor, "UM_code")), mo_Db.GetFields(ll_Cursor, "UM_desc")), True

    ms_CT_Code = mo_Db.GetFields(ll_Cursor, "CT_code")
    
    If Not cbo_status.SearchItem(ml_SS_Code, 0, 0) Then
        Call cbo_status.Load
        Call cbo_status.SearchItem(ml_SS_Code, 0, 0)
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ls_Req = Replace(REQ_GRD_WLD, "$SP_CAPKEY$", as_Key)
    ls_Req = Replace(ls_Req, "$Language_code$", ms_Language_Code)
    
    grd_WLD.Requests = ls_Req
    grd_WLD.Execute

    Exit Sub
ErrHandler:
    If ll_Cursor <> 0 Then Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Call ErrorHandler("Item_Load")
End Sub

Private Sub Item_ViewInit(ByVal as_Key As String)
On Error GoTo ErrHandler
    
    mb_Validated = False
    
    uc_CapSOMQuote.Visible = False
    
    'clear the frame record and disable frames
    Call ClearFrame(UserControl.Controls, fra_ProjDetail)
    
    Call Item_Load(as_Key)
    
    Call EnableFrame(UserControl.Controls, fra_ProjDetail, False)

    ReDim mt_WLDQuoteUpd(-1 To -1)

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_ViewInit")
End Sub

Private Sub cal_followUpDate_changeposition(y As Integer)
    cal_followUpDate.ZOrder 0
    cal_followUpDate.Top = cal_followUpDate.Top + y
End Sub


Private Sub cal_orderExpDate_changeposition(y As Integer)
    cal_orderExpDate.ZOrder 0
    cal_orderExpDate.Top = cal_orderExpDate.Top + y
End Sub

Private Sub tbl_WLD_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tbl_WLD.Enabled = False


    Select Case as_Role
        Case "I"
            grd_WLD.Refresh
        
        Case "W"
            Call ProjectWLDStatus(eQuoteWon)
            
        Case "L"
            Call ProjectWLDStatus(eQuoteLost)
                        
        Case "V"
            Call Item_ValidateWLD
        
        Case "T"
            ReDim mt_WLDQuoteUpd(-1 To -1)
            RaiseEvent quit
        
    End Select
    
    tbl_WLD.Enabled = True
    Call LockScreen(False)
    
    DoCheck = False
    
    Exit Sub
ErrHandler:
    
    DoCheck = False
    
    tbl_WLD.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
        Case Else
            Call LogMessage("tbl_WLD_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
            Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
            End
    
    End Select
End Sub


Private Sub Item_ValidateWLD()
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Cap_SOM_Quote_staus_upd $SQT_ID$, $SQT_Status$, $Z_creator$, $iConcurrency$"
Const C_REQ_SP As String = "EXEC Sales_Project_upd3 '$SP_CAPKEY$', $iConcurrency$ , $SS_CODE$"
Const C_TRAN_BEGIN      As String = "BEGIN TRAN QuoteUpdate"
Const C_TRAN_COMMIT     As String = "COMMIT TRAN QuoteUpdate"
Const C_TRAN_ROLLBACK   As String = "ROLLBACK TRAN QuoteUpdate"

    Dim nb_line As Long
    Dim lb_WonLost As Boolean
    Dim lb_InTrans As Boolean
    
    If grd_WLD.Rows = 0 Then Exit Sub
    
    grd_WLD.FirstLine
    lb_WonLost = False
    
    Do
        If grd_WLD.SelectedLine(0, "SQT_Status") <> eQuoteWon And grd_WLD.SelectedLine(0, "SQT_Status") <> eQuoteLost And grd_WLD.SelectedLine(0, "SQT_Status") <> eQuoteDuplicated Then
            Call MsgBox(MsgText(C_ERRORRAISE + 55, ms_Language_Code, "#You must indicate for each line whether the quotation is Won, Lost or Duplicated"), vbInformation)
            Exit Sub
        End If
        If grd_WLD.SelectedLine(0, "SQT_Status") = eQuoteWon Or grd_WLD.SelectedLine(0, "SQT_Status") = eQuoteLost Then
            lb_WonLost = True
        End If
    Loop While grd_WLD.NextLine
    
    'Task 473: at least,a line lost/won have to exist; all duplicate not allowed
    If lb_WonLost = False Then
        Call MsgBox(MsgText(C_ERRORRAISE + 68, ms_Language_Code, "#At least one line have to be Won or Lost."), vbInformation)
        Exit Sub
    End If
    
    
    ' 1. update statuses of all quotes
    Dim ls_Req As String
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_BEGIN)
    lb_InTrans = True
    
    ' 1. update lost and duplicated quotes
    Dim ll_i As Long
    For ll_i = 0 To grd_WLD.Rows - 1
        ls_Req = Replace(C_REQ, "$SQT_ID$", grd_WLD.Data(ll_i, "SQT_ID"))
        ls_Req = Replace(ls_Req, "$iConcurrency$", grd_WLD.Data(ll_i, "iConcurrency"))
        ls_Req = Replace(ls_Req, "$SQT_Status$", grd_WLD.Data(ll_i, "SQT_Status"))
        ls_Req = Replace(ls_Req, "$Z_creator$", ml_U_code)
        Call ExecuteSQLSafe(mo_Db, ls_Req, 1)
    Next ll_i
    
    ' 2. update status of a project
    ls_Req = Replace(C_REQ_SP, "$SP_CAPKEY$", ms_SP)
    ls_Req = Replace(ls_Req, "$iConcurrency$", ml_prjIconc)
    ls_Req = Replace(ls_Req, "$SS_CODE$", ml_SS_Code)
    Call ExecuteSQLSafe(mo_Db, ls_Req)
    
    Call ExecuteSQLSafe(mo_Db, C_TRAN_COMMIT)
    lb_InTrans = False
    mb_Validated = True

    ' 3. present won quote screens to update
    grd_WLD.Columns("SQT_Status").Key = True
    
    If grd_WLD.SearchKey(True, Array(eQuoteWon)) Then
    
        Call uc_CapSOMQuote.Move(0, 0, UserControl.Width, UserControl.Height)
        uc_CapSOMQuote.projectFinalization = ms_SP & CH_LDELIMIT & "E" & CH_LDELIMIT & ms_CT_Code & CH_LDELIMIT & ml_SS_Code

        uc_CapSOMQuote.CurrentKey(1) = grd_WLD.CurrentLine("SQT_ID")
        uc_CapSOMQuote.CurrentKey(2) = grd_WLD.CurrentLine("SQT_Status")

        uc_CapSOMQuote.DisplayMode = mt_CstValues.DisplayMode_Update
        uc_CapSOMQuote.ZOrder
        uc_CapSOMQuote.Visible = True
    Else
        ' just update lost/duplicate quotes
        Call uc_CapSOMQuote_Updated
    End If
    
    grd_WLD.Columns("SQT_Status").Key = False
    
    Exit Sub
ErrHandler:
    If lb_InTrans Then
        Call UpdateError(True)
        Call ExecuteSQLSafe(mo_Db, C_TRAN_ROLLBACK)
        lb_InTrans = False
        Call UpdateError(False)
    End If
    Call ErrorHandler("Item_ValidateWLD")
End Sub

Private Sub ProjectWLDStatus(ByVal am_status As eQuoteStatus)
On Error GoTo ErrHandler
    
    Dim ll_Nb As Long
    Dim ll_Count As Long
    
    grd_WLD.DeselectRow
    
    grd_WLD.Redraw = False
    
    ll_Nb = grd_WLD.Rows - 1
    
    For ll_Count = 0 To ll_Nb
        Select Case am_status
            Case eQuoteWon
                Select Case grd_WLD.Data(ll_Count, "SQT_Include")
                    Case eInclActive
                        grd_WLD.Data(ll_Count, "SQT_Status") = eQuoteWon
                        grd_WLD.Data(ll_Count, "Won") = "CHECK"
                        grd_WLD.Data(ll_Count, "Lost") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Duplicated") = "UNCHECK"
                    Case eInclMultiple
                        grd_WLD.Data(ll_Count, "SQT_Status") = eQuoteDuplicated
                        grd_WLD.Data(ll_Count, "Won") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Lost") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Duplicated") = "CHECK"
                End Select
            Case eQuoteLost
                Select Case grd_WLD.Data(ll_Count, "SQT_Include")
                    Case eInclActive
                        grd_WLD.Data(ll_Count, "SQT_Status") = eQuoteLost
                        grd_WLD.Data(ll_Count, "Won") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Lost") = "CHECK"
                        grd_WLD.Data(ll_Count, "Duplicated") = "UNCHECK"
                    Case eInclMultiple
                        grd_WLD.Data(ll_Count, "SQT_Status") = eQuoteDuplicated
                        grd_WLD.Data(ll_Count, "Won") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Lost") = "UNCHECK"
                        grd_WLD.Data(ll_Count, "Duplicated") = "CHECK"
                End Select
        End Select
        
    Next ll_Count

    grd_WLD.Redraw = True
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("ProjectWLDStatus")
End Sub

Private Sub grd_WLD_Click()
On Error GoTo ErrHandler
    
    Dim ll_Row As Long
    Dim ll_Col As Long
    
    ll_Row = grd_WLD.Row
    ll_Col = grd_WLD.Col
        
    grd_WLD.Redraw = False
    
    
    Select Case grd_WLD.Columns(ll_Col).Name
        Case "Won"
            grd_WLD.Data(ll_Row, "SQT_Status") = eQuoteWon
            grd_WLD.Data(ll_Row, "Won") = "CHECK"
            grd_WLD.Data(ll_Row, "Lost") = "UNCHECK"
            grd_WLD.Data(ll_Row, "Duplicated") = "UNCHECK"
        
        Case "Lost"
            grd_WLD.Data(ll_Row, "SQT_Status") = eQuoteLost
            grd_WLD.Data(ll_Row, "Won") = "UNCHECK"
            grd_WLD.Data(ll_Row, "Lost") = "CHECK"
            grd_WLD.Data(ll_Row, "Duplicated") = "UNCHECK"
        
        Case "Duplicated"
            grd_WLD.Data(ll_Row, "SQT_Status") = eQuoteDuplicated
            grd_WLD.Data(ll_Row, "Won") = "UNCHECK"
            grd_WLD.Data(ll_Row, "Lost") = "UNCHECK"
            grd_WLD.Data(ll_Row, "Duplicated") = "CHECK"
    End Select
    
    grd_WLD.Redraw = True
    
    Exit Sub
ErrHandler:
   
    Select Case Err.Number
    Case Else
        Call LogMessage("grd_WLD_Click: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
End Sub

Private Sub grd_WLD_RowLoaded(ByVal al_Row As Long)
On Error GoTo ErrHandler
    
    Select Case grd_WLD.Data(al_Row, "SQT_Status")
        Case eQuoteWon
            grd_WLD.Data(al_Row, "Won") = "CHECK"
            grd_WLD.Data(al_Row, "Lost") = "UNCHECK"
            grd_WLD.Data(al_Row, "Duplicated") = "UNCHECK"
            
        Case eQuoteLost
            grd_WLD.Data(al_Row, "Won") = "UNCHECK"
            grd_WLD.Data(al_Row, "Lost") = "CHECK"
            grd_WLD.Data(al_Row, "Duplicated") = "UNCHECK"
            
        Case eQuoteDuplicated
            grd_WLD.Data(al_Row, "Won") = "UNCHECK"
            grd_WLD.Data(al_Row, "Lost") = "UNCHECK"
            grd_WLD.Data(al_Row, "Duplicated") = "CHECK"
            
        Case eQuoteCancelled, eQuoteActive
            grd_WLD.Data(al_Row, "Won") = "UNCHECK"
            grd_WLD.Data(al_Row, "Lost") = "UNCHECK"
            grd_WLD.Data(al_Row, "Duplicated") = "UNCHECK"
    End Select
        
    Exit Sub
ErrHandler:
    
    Select Case Err.Number
    Case Else
        Call LogMessage("grd_WLD_RowLoaded: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
End Sub

Private Sub uc_CapSOMQuote_quit()
    uc_CapSOMQuote_Updated
End Sub


Private Sub uc_CapSOMQuote_Updated()
On Error GoTo ErrorHandler
    Dim lb_isfinalized As Boolean
    Dim ll_i As Long

    lb_isfinalized = False
    
    ' move to a next quote
    grd_WLD.Columns("SQT_Status").Key = True
    If grd_WLD.NextItem Then
    
        If grd_WLD.SearchKey(False, Array(eQuoteWon)) Then
        
                uc_CapSOMQuote.CurrentKey(1) = grd_WLD.CurrentLine("SQT_ID")
                uc_CapSOMQuote.CurrentKey(2) = grd_WLD.CurrentLine("SQT_Status")
                uc_CapSOMQuote.DisplayMode = mt_CstValues.DisplayMode_Update
                uc_CapSOMQuote.ZOrder
                uc_CapSOMQuote.Visible = True
        Else
            lb_isfinalized = True
        End If
    Else
        lb_isfinalized = True
    End If
    grd_WLD.Columns("SQT_Status").Key = False
    
    If lb_isfinalized Then
        ' move back and hide the grid and some icons
        uc_CapSOMQuote.Visible = False
        RaiseEvent quit

    End If
    Exit Sub
ErrorHandler:
    Call ErrorMessage(Extender.Name & ".uc_CapSOMQuote_Updated()")
End Sub
